import PerformanceClient from "@/components/performance/PerformanceClient";
import { Card, CardHeader, CardTitle, CardDescription } from "@/components/ui/card";
import { BarChart3 } from "lucide-react";

export default function PerformancePage() {
    return (
        <div className="container mx-auto py-8 px-4 sm:py-12">
            <div className="flex flex-col sm:flex-row sm:items-center gap-4 mb-8">
                <div className="bg-primary/10 rounded-lg p-3 w-fit h-fit">
                    <BarChart3 className="h-8 w-8 text-primary" />
                </div>
                <div>
                    <h1 className="text-3xl font-bold font-headline">Your Performance</h1>
                    <p className="text-muted-foreground">Track your quiz history and scores over time.</p>
                </div>
            </div>
            <PerformanceClient />
        </div>
    );
}